# Charity Notes 02: 塔木德的慈善

本节课最主要讲的是来自塔木德的 Tzedekah 概念。本节课主要引用 ==Greg Gardner== 的著作，他在书中提到了Porat的“田野政策”（the laws of ==pe’ah==, gleaning and forgotten things），并称之为 “**harvest-time allocations**”。Porat 和 Gardner 得出的共同结论是，<u>圣经中的社会福利方法与农业社会密切相关。当后来犹太人来到城市以后，塔木德拉比们觉得有必要补充一些这样的方法</u>。

这节课的主要内容是理解 Tzedekah 这个词，也就是慈善。公认的学术观点认为在圣经的大部分内容中，这个词被翻译为一般的**正义**而没有特定的给予行为。但在早期的 Tannaim 的关于Tzedekah 论述中，这仅仅是 “给穷人捐助金钱”。在后来的拉比文本中，tsedaqah 的意义扩展为慈善的各种各样的努力。塔木德拉比还在城市中建立了两个慈善机构，“**quppa**” 和 “**tamhui**”，来帮助穷人。



## Tzedekah 和慈善的概念

在希伯来圣经中，Tzedekah 这个词被发现大约150次，它意味着“正义” （righteousness）—— 一个宽广的概念，表示正确的生活或正确的行为。在希伯来圣经中 Tzedekah 从不意味着慈善或救济。只有在希腊化时代（Hellenistic era），我们才开始将慈善作为正义行为的**特定表达**。包括在 Tobit 和死海古卷（Dead Sea Scrolls） 的资料中，慈善（Tzedekah）意为救济（almsgiving）。然而，这些仅仅是少数几个实例，它们的意义不应过分夸大。



## 早期 Tannaim 解读慈善

Tannaim 是犹太经典**米书拿**（Mishna，即口传托拉） 中记载的拉比，意为老师，米书拿大约成书于2世纪。早期拉比文本（==[Tannaitic](https://en.wikipedia.org/wiki/Tannaim) texts==）中 tsedaqah 开始从“正义”到“慈善”演变。

在申命记中，经文劝告人们在安息年取消之前几年内向穷人提供的贷款。**早期的“慈善”拉比概念比现代对该术语的理解更为具体和狭隘。**在t. Pe’ah 4:19中，Tannaim将tsedaqah定义为<u>对生活贫困者的金钱支持</u>。而Pe'ah 4:8-21，表明 tsedaqah 也可以实物，包括食物，衣服和住所。综上所述，==早期的犹太教慈善概念化==将tsedaqah定义为**生活贫困者的物质条款**（tsedaqah as **material provisions** for the living poor）。

- 首先，物质支持意味着==个人==服务（personal services）。例如探访病人被排除在早期拉比的tsedaqah概念之外。
- 其次，慈善事业是为了==生活==。因此，埋葬死者并不被认为（在 Tannaitic compilations）是tsedaqah的行为。
- 第三，慈善是==针对穷人==的。不一定包括寡妇，孤儿（widows，orphans）或其他有需要的个人。

因为它专门针对贫穷的男性，所以Tannaim不会考虑把对犹太教堂，拉比们或学校的贡献作为慈善。简而言之，早期拉比文本中的“慈善”或者tsedaqah是一个狭隘的概念。而从**Amoraim**开始，这些类型的贡献才慢慢被后来的拉比们视为“慈善”。



## 其他帮助穷人的方式

除了慈善以外还有其它帮助穷人的方式，这些其实我们在上一讲有详细描述，比如花絮，田野政策。这个政策不是为了他人的，而被认为是受惠**上帝**，而不是人类。

首先，虽然收获时间分配法律和慈善机构是不同的，但它们也是互补的，因为它们在两个不同的环境中解决贫困问题。

- 收获时分配的法律规定了农村环境，很容易看出贫穷的农民最容易获得什么，收集和遗忘的东西。
- **慈善机构是城镇贫困人口的理想解决方案。**在人口稠密的地区征求个人施舍是最有效的，因为穷人可以将自己置于交通繁忙的地方（例如市场和寺庙附近），以增加他们接受施舍的机会。此外，慈善机构（特别是quppa）由希腊罗马的公民文化塑造，因为它们与城市景观中的其他机构并列。

第二，虽然对穷人的两种形式的支持相互补充，但在某些方面，它们也是**重叠**的，因为它们都以同一受益者为目标。所有贫困人口都有资格获得收获时间的分配以及来自tamhui的施舍。